% Copyright (c) 2013, Massachusetts Institute of Technology
% This program was presented in the book "Visual Psychophysics:
% From Laboratory to Theory" by Zhong-Lin Lu and Barbara Dosher.
% The book is available at http://mitpress.mit.edu/books/visual-psychophysics

%%% FourierFiltering.m
[M,  map] = imread('Church.jpg',  'jpeg');    
M1 = rgb2gray(M);
fM = fftshift(fft2(M1 - mean2(M1))); %Fourier transformation
maxfM = max(max(log(abs(fM))));
showImage(uint8(256*log(abs(fM))/maxfM),   'grayscale');
Sz = size(M1);
[x,  y] = meshgrid(-Sz(2)/2:(Sz(2)/2-1),  ...
          Sz(1)/2:-1:-(Sz(1)/2-1));
r = sqrt(x.^2 + y.^2);
r0 = 64;
s1 = 10;

% Lowpass filtering
lowpass = (r <= r0) + (r > r0).*exp(-(r - r0).^2/2/s1^2); 
        % Construct a lowpass filter
showImage(uint8(256*lowpass),  'grayscale');
fMl = fM.*lowpass;  % Apply the lowpass filter to the 
                    % Fourier spectrum
showImage(uint8(256*log(abs(fMl) + 1)/maxfM),   'grayscale');
M2 = uint8(ifft2(fftshift(fMl)) + mean2(M1) );  
        % Inverse Fourier transformation
showImage(M2,   'grayscale');

% Highpass filtering
highpass = (r >= r0) + (r < r0).*exp(-(r - r0).^2/2/s1^2); 
        % Construct a highpass filter
showImage(uint8(256*highpass),   'grayscale');
fMh = fM.*highpass; % Apply the highpass filter to the 
                    % Fourier spectrum
showImage(uint8(256*log(abs(fMh) + 1)/maxfM),   'grayscale');
M3=uint8(ifft2(fftshift(fMh)) + mean2(M1) );  
        % Inverse Fourier transformation
showImage(M3,   'grayscale');

% Bandpass filtering
bandpass = exp(-(r - r0).^2/2/s1^2); 
        % Construct a bandpass filter
showImage(uint8(256*bandpass),   'grayscale');
fMb = fM.*bandpass; % Apply the bandpass filter to the 
                    % Fourier spectrum
showImage(uint8(256*log(abs(fMb) + 1)/ maxfM),   'grayscale');
M4 = uint8(ifft2(fftshift(fMb)) + mean2(M1) );  
        % Inverse Fourier transformation
showImage(M4,   'grayscale');

